#include <iostream>
#include <string>

#include <thrift/protocol/TBinaryProtocol.h>
#include <thrift/server/TThreadedServer.h>
#include <thrift/transport/TServerSocket.h>
#include <thrift/transport/TBufferTransports.h>

#include "src/Worker_impl.hpp"

using namespace ::apache::thrift;
using namespace ::apache::thrift::protocol;
using namespace ::apache::thrift::transport;
using namespace ::apache::thrift::server;

void serving(int myPort, int glpkMegaMemLimit) {
	TThreadedServer * workerServer;
	try {
		boost::shared_ptr<Worker_impl> handler(new Worker_impl(glpkMegaMemLimit));
		boost::shared_ptr<TProcessor> processor(new RemoteProcessor(handler));
		boost::shared_ptr<TServerTransport> serverTransport(
			new TServerSocket(myPort)
		);
		boost::shared_ptr<TTransportFactory> transportFactory(
			new TBufferedTransportFactory()
		);
		boost::shared_ptr<TProtocolFactory> protocolFactory(
			new TBinaryProtocolFactory()
		);
		workerServer = new TThreadedServer(
			processor, serverTransport, transportFactory, protocolFactory
		);
		workerServer->serve();
	} catch(TException & tx) {
		std::cerr << tx.what() << "\n";
	}
}

int main(int argc, char **argv) {
	std::string modus;

	if(argc<3) {
		std::cout << "usage: " << argv[0] << " <port> <max MB>\n";
		return 1;
	}

	int myPort = std::stoi(argv[1]);
	int mb     = std::stoi(argv[2]);

	Worker_impl::_kill = false;
	Worker_impl::_silent = false;
	std::cout<<"running on Port " << myPort <<"\n";

	serving(myPort, mb);
	return 0;
}
