#ifndef _JOBTOOL_HPP
#define _JOBTOOL_HPP 1

#include <string>
#include <vector>
#include <glpk.h>
#include "thrift/gen-cpp/Remote_types.h" // Job, Obj, Configurator

class JobTool {

public:
	static double BAD_OptNBound;

	static Job               create(const int & timeout);
	static Job            createEnd();
	// Der Validitaetscheck wird durch simplex/MIP auf worker erledigt!
	//static bool             isValid(const Job & j, const Instance & in);
	static bool               isEnd(const Job & j);
	static int             deepness(const Job & j);
	static void      clearBestBound(Job & j);
	
	static double          compare(const Job & ret, const Job & val);
	static double          compare(const Job & ret, const double & val);
	static std::string    toString(const Job & j);
	static std::string fixToString(const Job & j);
	
	static Column findLazyByAt(const Job & job, const Obj * in, int i);

	static std::vector<Job>  branch( 
		std::vector<double> sim,
		Job job,
		const Obj * in,
		const Configurator * conf
	);
};
#endif
