#include <iostream>
#include <sstream>
#include <vector>
#include <math.h>
#include <glpk.h>
#include "JobTool.hpp"
#include "thrift/gen-cpp/Remote_types.h"
using namespace std;

double JobTool::BAD_OptNBound;


// =====================================================================
double JobTool::compare(const Job & ret, const Job & val) {
	return (ret._opt - val._opt);
}

// =====================================================================
double JobTool::compare(const Job & ret, const double & val) {
	return ((double)ret._opt - val);
}

// =====================================================================
string JobTool::toString(const Job & j) {
	ostringstream os;
	os << j._opt << "_";
	/// @todo Das ist alles sehr unvariable und unfein
	for (unsigned i = 0; i < j._fix.size(); ++i) {
		os << to_string((int) j._fix[i]);
	}
	return os.str();
}

// =====================================================================
string JobTool::fixToString(const Job & j) {
	ostringstream os;
	for (auto l : j._lazy) {
		if (l.type == GLP_LO) {
			os << l.lower << "<=x" << l.at << " ";
		} else if (l.type == GLP_UP) {
			os << "x" << l.at << "<=" << l.upper << " ";
		} else if (l.type == GLP_DB) {
			os << l.lower << "<=x"<< l.at << "<=" << l.upper << " ";
		} else if (l.type == GLP_FX) {
			if (l.kind == GLP_BV) {
				os << l.lower << "-";
			} else {
				os << "x"<< l.at << "=" << l.lower << " ";
			}
		} else {
			// free = no bounds !
			// l.type == GLP_FR
			;
		}
	}
	os << " " << j._timeout << "ms";
	return os.str();
}

// =====================================================================
bool JobTool::isEnd(const Job & j) {
	return (j._end == true);
}

// =====================================================================
Job JobTool::createEnd() {
	Job _return;
	_return._opt = JobTool::BAD_OptNBound;
	_return._fix.clear();
	_return._lazy.clear();
	_return._end = true;
	_return._bestBound = JobTool::BAD_OptNBound;
	_return._timeout = -1;
	return _return;
}

// =====================================================================
Job JobTool::create(const int & timeout) {
	Job _return;
	_return._opt = JobTool::BAD_OptNBound;
	_return._fix.clear();
	_return._lazy.clear();
	_return._end = false;
	_return._bestBound = JobTool::BAD_OptNBound;
	_return._timeout = timeout;
	return _return;
}

// =====================================================================
Column JobTool::findLazyByAt(const Job & job, const Obj * in, int i) {
	i += 1;
	for (auto laz : job._lazy) {
		if (laz.at == i) return laz;
	}
	return in->cols[i-1];
}

// =====================================================================
vector<Job> JobTool::branch( vector<double> sim, Job job, const Obj * in, const Configurator * conf ) {

	list<Job> res;

	job._opt = JobTool::BAD_OptNBound;
	job._fix = sim;
	job._lastK = job._lazy.size();
	int K = conf->K;
	int n  = in->cols.size();

	int kLimit = (conf->timeoutEndProcent/100.0) * n;
	if (kLimit <= (job._lastK + K)) {
		job._timeout = -1; // job run to the end with no timeout
	} else {
		if (job._lastK > 0) job._timeout *= conf->factor;
	}
	
	res.push_back(job);
	Job jDummy;
	int cnt = 0;
	int i,j,len;
	for (i = 0; cnt < K && i < n; ++i) {
		// darf nicht angepasst werden, weil ist schon fix
		if (in->cols[i].type == GLP_FX) continue;
		
		/* suche aus bisheriger _lazy des Jobs den
		 * bestehenden Bound-Type heraus UND
		 * nutze ggf original Bound aus "in" für diese variable,
		 * was -if- zeile mit "in->cols[i]" überflüssig machen könnte
		 * (bleibt aus performancegründen aber drin).
		 */
		Column oldLazy = JobTool::findLazyByAt(job, in, i);
		if (oldLazy.type == GLP_FX) continue;
		
		if (
			( (in->cols[i].kind == GLP_IV) || (in->cols[i].kind == GLP_BV) ) // Ganzzahlig erwartet ...
			// aktuelle machen wir keine
			// Vorbelegung bei kontinuierlichen, wie z.B. 
			// sim[3] = 7.31 und 0 < x3 < 900 wird zu 3 statt 2 Jobs
			//   lazy1: 0 < x3 < 7.31 und
			//   lazy2: x3 = 7.31 (Variable-type FIX) und
			//   lazy3: 7.31 < x3 < 900
			&& (ceil(sim[i]) != sim[i]) // ... aber simplex liefert nachkommastellen
		) {
			len = res.size();
			for (j = 0; j < len; ++j) {
				// alten Job entnehmen und entfernen
				jDummy = res.front();
				res.pop_front();
				
				// Kopie für 2 neue Jobs anlegen (up und low als Namensgebung eigentlich schlecht!)
				Job jUp = jDummy;
				Job jLow = jDummy;
				Column lazUp;
				Column lazLow;
				lazUp.at = i+1;
				lazLow.at = i+1;
				
				// Anpassung der Grenzen durch Vorbelegung ---------------------------------------- START

				if (in->cols[i].kind == GLP_BV) { // --------------------------------binär
					
					lazUp.type  = GLP_FX;
					lazLow.type = GLP_FX;
					jUp._fix[i]  = 1.0;
					jLow._fix[i] = 0.0;
					lazUp.lower = 1.0;
					lazUp.upper = 1.0; // ignored
					lazLow.lower = 0.0;
					lazLow.upper = 0.0; // ignored
					
				} else {
					double highV = ceil(sim[i]);
					double lowV = floor(sim[i]);
					
					// --------------------------------------------------------------
					// muss man zwischen maximierung und minimierung hier unterscheiden?
					//if (in->isMax == true) {
					
					if (oldLazy.type == GLP_UP) {                   // hat obere Grenze
						/* sim[i] = 5.3 wird zu
						 *   ist obere grenze < 5.3 // simplex hätte kein 5.3 erzeugt!!
						 *     continue
						 * 
						 *   ist obere grenze == 5.3 (der fall könnte später bei contiuous Variabel vorbelegung interessant sein)
						 *     ub  <= x[i] <= 6 ????
						 *     inf <  x[i] <= 5
						 *    oder
						 *     x[i] = 5.3
						 *     inf < x[i] <= 5
						 *    ???
						 * 
						 *   ist obere grenze == 6
						 *     x[i] = 6
						 *     inf <  x[i] <= 5
						 * 
						 *   ist obere grenze > 6 // else-zweig
						 *       6 <= x[i] <= ub
						 *     inf <  x[i] <= 5
						 */
						if (oldLazy.upper < sim[i]) {
							// fall gibt es bei GLP_UP nicht
							continue;

						} else if (oldLazy.upper == sim[i]) { // ????
							continue;
							
						} else if (oldLazy.upper == highV) {
							jLow._fix[i] = highV;
							lazLow.type  = GLP_FX;
							lazLow.lower = highV;
							lazLow.upper = highV; // ignored
							
							jUp._fix[i] = lowV;
							lazUp.type  = GLP_UP;
							lazUp.lower = lowV-1; // ignored
							lazUp.upper = lowV;
							
						} else {
							jLow._fix[i] = highV;
							lazLow.type  = GLP_DB;
							lazLow.lower = highV;
							lazLow.upper = oldLazy.upper;
							
							jUp._fix[i] = lowV;
							lazUp.type  = GLP_UP;
							lazUp.lower = 0.0; // ignored
							lazUp.upper = lowV;
						}

					} else if (oldLazy.type == GLP_LO) {            // hat untere Grenze
						/* sim[i] = 5.3 wird zu
						 *   ist untere grenze > 5.3 // simplex hätte kein 5.3 erzeugt!!
						 *     continue
						 * 
						 *   ist untere grenze == 5.3 (der fall könnte später bei contiuous Variabel vorbelegung interessant sein)
						 *     ???
						 * 
						 *   ist untere grenze == 5
						 *     x[i] = 5
						 *     6 <= x[i] < inf
						 * 
						 *   ist untere grenze < 5 // else-zweig
						 *     lb <=  x[i] <= 5
						 *     6  <=  x[i] < inf
						 */

						if (oldLazy.lower > sim[i]) {
							// fall gibt es bei GLP_UP nicht
							continue;

						} else if (oldLazy.lower == sim[i]) { // ????
							continue;
							
						} else if (oldLazy.lower == lowV) {
							jLow._fix[i] = lowV;
							lazLow.type  = GLP_FX;
							lazLow.lower = lowV;
							lazLow.upper = lowV; // ignored
							
							jUp._fix[i] = highV;
							lazUp.type  = GLP_LO;
							lazUp.lower = highV;
							lazUp.upper = highV+1; // ignored
							
						} else {
							jLow._fix[i] = lowV;
							lazLow.type  = GLP_DB;
							lazLow.lower = oldLazy.upper;
							lazLow.upper = lowV;
							
							jUp._fix[i] = highV;
							lazUp.type  = GLP_LO;
							lazUp.lower = highV;
							lazUp.upper = highV+1; // ignored
						}
						
					} else if (oldLazy.type == GLP_DB) {            // hat beide Grenzen
						/* sim[i] = 5.3 wird zu
						 *   ist lb == 5 und ub > 6
						 *     x = 5
						 *     6 < x < ub
						 * 
						 *   ist lb == 5 und ub == 6
						 *     x = 5
						 *     x = 6
						 * 
						 *   ist lb < 5 und ub == 6
						 *     lb < x < 5
						 *     x == 6
						 *     
						 *   ist lb < 5 und ub > 6 // else-zweig
						 *     lb < x < 5
						 *     6  < x < ub
						 */
						if ((oldLazy.lower == lowV) && (oldLazy.upper > highV)) {
							jLow._fix[i] = lowV;
							lazLow.type  = GLP_FX;
							lazLow.lower = lowV;
							lazLow.upper = lowV; // ignored
							
							jUp._fix[i] = highV;
							lazUp.type  = GLP_DB;
							lazUp.lower = highV;
							lazUp.upper = oldLazy.upper;
							
						} else if ((oldLazy.lower == lowV) && (oldLazy.upper == highV)) {
							jLow._fix[i] = lowV;
							lazLow.type  = GLP_FX;
							lazLow.lower = lowV;
							lazLow.upper = lowV; // ignored
							
							jUp._fix[i] = highV;
							lazUp.type  = GLP_FX;
							lazUp.lower = highV;
							lazUp.upper = highV; // ignored
							
						} else if ((oldLazy.lower < lowV) && (oldLazy.upper == highV)) {
							jLow._fix[i] = lowV;
							lazLow.type  = GLP_DB;
							lazLow.lower = oldLazy.lower;
							lazLow.upper = lowV;
							
							jUp._fix[i] = highV;
							lazUp.type  = GLP_FX;
							lazUp.lower = highV;
							lazUp.upper = highV; // ignored

						} else {
							jLow._fix[i] = lowV;
							lazLow.type  = GLP_DB;
							lazLow.lower = oldLazy.lower;
							lazLow.upper = lowV;
							
							jUp._fix[i] = highV;
							lazUp.type  = GLP_DB;
							lazUp.lower = highV;
							lazUp.upper = oldLazy.upper;
						}

					} else {                                        // Frei
						/* sim[i] = 5.3 wird zu
						 *    6 <= x[i] < inf
						 *  inf <  x[i] <= 5
						 */

						// untere Grenze bekommt entsprechenden aufgerundeten Wert
						jLow._fix[i] = highV;
						lazLow.type  = GLP_LO;
						lazLow.upper = highV+1; // ignored
						lazLow.lower = highV;
						
						// obere Grenze bekommt entsprechenden abgerundeten Wert
						jUp._fix[i] = lowV;
						lazUp.type  = GLP_UP;
						lazUp.upper = lowV;
						lazUp.lower = lowV-1; // ignored
					}
					
				}
				// Anpassung der Grenzen durch Vorbelegung --------------------------------------- STOP
				
				// einfügen
				lazUp.kind  = in->cols[i].kind; // variable-Type ändert sich nicht
				lazLow.kind = in->cols[i].kind; // variable-Type ändert sich nicht
				jUp._lazy.push_back(lazUp);
				jLow._lazy.push_back(lazLow);
				res.push_back(jUp);
				res.push_back(jLow);
			}
			cnt += 1;
		}
	}

	// list -> vector
	vector<Job> ret(res.begin(), res.end());
	return ret;
}

// =====================================================================
int JobTool::deepness(const Job & j) {
	return j._lazy.size();
}

// =====================================================================
void JobTool::clearBestBound(Job & j) {
	j._bestBound = JobTool::BAD_OptNBound;
}

